﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Switches : RPGByteData
    {
        List<Switch> switches;
        
        public Switches(FileStream f)
        {
            load(f);
        }
        public Switches()
        {
        }
        
        override public void load(FileStream f)
        {
            switches = M.readDatabaseList<Switch>(f, "Switches", "Switch", ref M.switchNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Switch>(switches);
        }
    }
    
    class Switch : RPGDatabaseEntry
    {
        int id = 0;
        string switchName = ""; // 01
        
        List<int> chunkList;
        
        public Switch(FileStream f)
        {
            load(f);
        }
        public Switch()
        {
        }
        
        public void load(FileStream f)
        {
            chunkList = new List<int>();
            
            id = M.readMultibyte(f);
            
            if (Chunks.next(f, 0x01, chunkList))
                switchName = M.readStringDataName(f, id, ref M.switchNames, M.S_UNTRANSLATED);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (Chunks.wasNext(0x01, chunkList))
                M.writeString(switchName, M.S_UNTRANSLATED);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (switchName != "") // 01
                return false;
            
            return true;
        }
    }
}
